CREATE PROCEDURE CPJU_Fact_Lote_Recalcular_Precios @pJsonRecibido VARCHAR(8000)
AS

DECLARE	@pFecha_Desde datetime,
	    @pFecha_Hasta datetime,
	    @pId_Tipo_cbte VARCHAR(4),
		@pLote VARCHAR(50),
        @pId_Lote_Tipo INT		

        SET @pFecha_Desde			= ISNULL(CONVERT(DATETIME, dbo.CF_JSON_VALUE(@pJsonRecibido,'Fecha_Desde')),GETDATE())
        SET @pFecha_Hasta			= ISNULL(CONVERT(DATETIME, dbo.CF_JSON_VALUE(@pJsonRecibido,'Fecha_Hasta')),GETDATE())
        SET @pId_Tipo_Cbte			= ISNULL(CONVERT(VARCHAR(4), dbo.CF_JSON_VALUE(@pJsonRecibido,'Id_Tipo_Cbte')),'CUP')
        SET @pLote			        = ISNULL(CONVERT(VARCHAR(50), dbo.CF_JSON_VALUE(@pJsonRecibido,'Lote')), '')
  	    SET @pId_Lote_Tipo	        = ISNULL(CONVERT(INT, dbo.CF_JSON_VALUE(@pJsonRecibido,'Id_Lote_Tipo')), 1)

	/*Variable de Retorno del Stored*/

	DECLARE @rtaErrorStored						INT
	DECLARE @rtaMsjStored						VARCHAR(4000)
	DECLARE @Result_Stored_Invocado				INT
	DECLARE @JSON_Parametros_Stored_Invocado	VARCHAR(8000)

	DECLARE @Result_Tabla_Stored_Invocado TABLE (ErrorNumber	INT,
										       	 ErrorSeverity	INT,
											     ErrorState		INT,
											     ErrorProcedure VARCHAR(1000),
											     ErrorLine		INT,
											     ErrorMessage	VARCHAR(4000))

BEGIN TRY 

BEGIN TRAN
/*   Atención esto recalcula el importe de comprobantes, solo sirve para las empresas que no tiene contabilidad

	Y que no tiene facturas electrónicas.
	El proceso de aumento para el resto de la empresas es generar el cbte. por la diferenica.

*/

/*
   Select Lote Into #Cbtes_lotes from Cbtes_Lotes where Id_Lote_Tipo = @pId_Lote_Tipo or Lote = '' or Lote is null


   PRINT @pLote

   If @pLote <> ''
      Delete  #Cbtes_lotes where Lote <> @pLote


   PRINT @pId_Tipo_cbte
   PRINT @pId_Lote_Tipo

   select c.id_cliente,c.id_trans,i.id_producto,i.cantidad,i.precio_grav
                ,dbo.SF_Categ_Precio(k.id_tipo_cli,k.id_lista_precio,k.id_cliente,getdate()) as precio_calculado
                Into #Diferencias
                from cbtes c, cbtes_items i, clientes k, #Cbtes_lotes L
                where c.id_trans = i.id_trans 
				      and c.id_tipo_cbte = @pId_Tipo_cbte
                      and c.saldo <> 0 
					  and c.id_estado_cbte = 1
					  and c.Lote = L.Lote
                      and c.id_cliente = k.id_cliente
	                  AND C.FECHA >= @pFecha_Desde 
	                  AND C.FECHA < dateadd(dd,1,@pFecha_Hasta)

                      

	select id_trans,sum(cantidad*precio_calculado) as imp_total 
		   into #Trans_a_Procesar from #Diferencias group by Id_Trans


    set @rtaErrorStored = isnull((select count(*) from #Trans_a_Procesar),0)
	
	PRINT @rtaErrorStored


	update cbtes_items SET precio_grav = d.precio_calculado,
						  imp_gravado = d.precio_calculado,
						  precio = d.precio_calculado,
						  imp_final = d.precio_calculado
					 from cbtes_items i, #Trans_a_Procesar p, #Diferencias D
						  where p.id_trans = i.id_trans 
							and p.id_trans = d.id_trans 
							and I.id_Producto = d.id_Producto
							and I.id_cliente = D.id_cliente

	update cbtes  set imp_exento = i.imp_total, imp_total = i.imp_total, saldo = i.imp_total
						  from cbtes  c, #Trans_a_Procesar I
						  where c.id_trans = i.id_trans 

	update clientes_ctacte  set importe = k.imp_total, saldo = k.imp_total
						  from clientes_ctacte c, #Trans_a_Procesar K
						  where  c.id_trans = k.id_trans
                   
	update cbtes_ctas_contables_DIFE  set debe = c.imp_total 
						  from #Trans_a_Procesar c, cbtes_ctas_contables k
						  where  c.id_trans = k.id_trans
						  and k.debe <> 0

	update cbtes_ctas_contables_DIFE  set haber = c.imp_total 
						  from #Trans_a_Procesar c, cbtes_ctas_contables k
						  where c.id_trans = k.id_trans
						  and k.haber <> 0

   DROP TABLE #Diferencias
   DROP TABLE #Trans_a_Procesar
   DROP TABLE #Cbtes_lotes
*/
   COMMIT TRAN

   SELECT	 0				 AS ErrorNumber 
			,0				 AS ErrorSeverity  
			,0				 AS ErrorState 
			,0			     AS ErrorProcedure  
			,0               AS ErrorLine		
			,@rtaErrorStored AS ErrorMessage

 			
END TRY 

BEGIN CATCH  
    EXECUTE usp_GetErrorInfo
	ROLLBACK
	RETURN 9999
END CATCH
RETURN 0 
 



 /*
  
  EXEC dbo.CPJU_FACT_LOTE_RECALCULAR_PRECIOS '{
			"Fecha_Desde":"20220801",
			"Fecha_Hasta":"20220905",
			"Id_Tipo_Cbte":"ND"}'

EXEC CPJU_Fact_Lote_Recalcular_Precios '{"Fecha_Desde":"20220801","Fecha_Hasta":"20220831","Lote":"LOTE_2022-08_","Id_Lote_Tipo":"1","Id_Tipo_Cbte":"ND" }'
  
EXEC CPJU_Fact_Lote_Recalcular_Precios '{"Fecha_Desde":"20220801","Fecha_Hasta":"20220831","Lote":"","Id_Lote_Tipo":"1","Id_Tipo_Cbte":"ND" }'

SELECT * FROM CBTES WHERE LOTE = 'LOTE_2022-08_'

update CBTES set saldo = 10000 WHERE LOTE = 'LOTE_2022-08_'
*/
 